/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.message;

import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.toolkit.designer.message.VWSIMValidationToolTip;
import filenet.sim.toolkit.designer.message.images.VWSIMImageLoader;
import filenet.vw.base.VWDebug;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class VWSIMValidationErrorLevelTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private ImageIcon m_errorIcon = null;
    private ImageIcon m_warningIcon = null;

    public VWSIMValidationErrorLevelTableCellRenderer() {
        try {
            this.setOpaque(true);
            this.m_errorIcon = VWSIMImageLoader.createImageIcon("error.gif");
            this.m_warningIcon = VWSIMImageLoader.createImageIcon("warning.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ImageIcon icon = null;
        VWScenarioValidationError error = (VWScenarioValidationError)value;
        if (error != null) {
            switch (error.getLevel()) {
                case 1: {
                    icon = this.m_errorIcon;
                    break;
                }
                case 2: {
                    icon = this.m_warningIcon;
                }
            }
        }
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        this.setIcon(icon);
        this.setText(null);
        this.setToolTipText(VWSIMValidationToolTip.createValidationToolTip(error));
        this.setComponentOrientation(table.getComponentOrientation());
        return this;
    }
}

